/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: port.c,v 1.9 2005/06/29 00:23:16 eugene Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

void
mx_endpoint_sock_init(struct mx_endpoint *endpoint)
{
  endpoint->sock_count = 0;
}

void
mx_endpoint_sock_insert(struct mx_endpoint *endpoint,
		      int sock)
{
  endpoint->read_sock[endpoint->sock_count].fd = sock;
  endpoint->read_sock[endpoint->sock_count].events = (POLLIN |
					      POLLPRI |
					      POLLERR |
					      POLLHUP |
					      POLLNVAL);
  endpoint->read_sock[endpoint->sock_count].revents = 0;
  endpoint->sock_count++;
}

void
mx_endpoint_sock_remove(struct mx_endpoint *endpoint,
		      int sock)
{
  int i;
  /* XXX assert (endpoint->_sock_count >  0); */
  for (i = 0; i < endpoint->sock_count; ++i) {
    if (endpoint->read_sock[i].fd == sock) {
      break;
    }
  }
  /* XXX assert (i < endpoint->_sock_count); */
  endpoint->read_sock[i].fd = endpoint->read_sock[endpoint->sock_count].fd;
  endpoint->read_sock[i].events = endpoint->read_sock[endpoint->sock_count].events;
  endpoint->read_sock[i].revents = endpoint->read_sock[endpoint->sock_count].revents;
  endpoint->sock_count--;
}

int
mx_endpoint_sock_ready(struct mx_endpoint *endpoint,
		     int sock)
{
  int i;
  short ready = (POLLIN | POLLPRI);

  for (i = 0; i < endpoint->sock_count; ++i) {
    if (sock == endpoint->read_sock[i].fd) {
      break;
    }
  }
  if (i == endpoint->sock_count) {
    return 0;
  }
  if ((endpoint->read_sock[i].revents & ready)) {
    return 1;
  }
  return 0;
}

int
mx_endpoint_sock_bad(struct mx_endpoint *endpoint,
		   int sock)
{
  int i;
  short bad = (POLLERR | POLLHUP | POLLNVAL);

  for (i = 0; i < endpoint->sock_count; ++i) {
    if (sock == endpoint->read_sock[i].fd) {
      break;
    }
  }
  if (i == endpoint->sock_count) {
    return 0;
  }
  if ((endpoint->read_sock[i].revents & bad)) {
    return 1;
  }
  return 0;
}
